/*
 * QrfeTagInterface.h
 *
 *  Created on: 30.07.2009
 *      Author: stefan.detter
 */

#ifndef QRFETAGINTERFACE_H_
#define QRFETAGINTERFACE_H_

#include <QByteArray>

#include "../QrfeTagManipulatorInterface.h"

class QrfeReaderInterface;

class QrfeTagInterface : public QObject
{
	Q_OBJECT

public:
	QrfeTagInterface(QString tagId, QrfeTagManipulatorInterface* reader, QObject* parent = 0);
	~QrfeTagInterface();

    QString tagId();
	QByteArray 	tagIdBytes();

	QString manufacturer();
	QString model();
	QString	userMemSize();

	bool 	hasSerialNr();
	QString serialNr();

	virtual QrfeReaderInterface*			readerInterface();
	virtual QrfeTagManipulatorInterface*	tagManipulatorInterface();


	virtual QrfeGlobal::TMIResult 	readInformations() = 0;


signals:
	void stepDone ( int curStep, int maxSteps );


protected:
	QString 						m_tagId;
	QrfeTagManipulatorInterface*	m_reader;

	QString 						m_manufacturer;
	QString 						m_model;
	int								m_userMemSize;

	bool 							m_hasSerialNumber;
	quint64 						m_serialNumber;
};



#endif /* QRFETAGINTERFACE_H_ */
